SET SQL_SAFE_UPDATES=0;

SET @dydtdataproviderId=(SELECT id FROM dydt_data_provider WHERE `providerName`='ADMISSION_DATA_PROVIDER');

UPDATE `dydt_data_line_item`
SET 
    `sqlSelectQueryDef` ='SELECT  p.programCode AS program_code,p.programName AS program_name,p.programNameToBePrint AS program_print_name,
   pd.shortCode AS primary_dept_code,pd.deptName AS primary_dept_name,
   psd.shortCode AS secondary_dept_code,psd.deptName AS secondary_dept_name,
   b.batchName AS batch_name ,b.startDate AS batch_start_date ,b.tillDate AS batch_tilldate,
   ay.itemCode AS academic_year ,a.code AS admission_code ,a.studentId as student_id
   FROM admission a
   LEFT JOIN programs p ON a.programId = p.id
   LEFT JOIN prog_batch_seat_config pbsc ON a.programBatchSeatConfigId = pbsc.id
   LEFT JOIN batches b   ON b.id = pbsc.programBatchId
   LEFT JOIN intake_year ay ON ay.id = b.intakeYearId
   LEFT JOIN department pd ON pd.id = p.programDepartmentId
   LEFT JOIN department psd ON psd.id = p.subDepartmentId'
WHERE
`dataSourceCode` = 'ADMISSION_INFO' AND dataProviderId = @dydtdataproviderId AND whereClauseBindingDef='PRM_ADMISSION_ID';
 
SET SQL_SAFE_UPDATES=1;
